/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "SurfaceRemoveNativeContentCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include <sstream>
#include "stdio.h"

ExecutionResult SurfaceRemoveNativeContentCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_surfaceId);

    if (surface)
    {
        if (surface->hasNativeContent())
        {
            surface->removeNativeContent();
            result = ExecutionSuccessRedraw;
        }
        else
        {
            this->setIlmError(ILM_ERROR_INVALID_ARGUMENTS);
            result = ExecutionSuccess;
        }
    }
    else
    {
        this->setIlmError(ILM_ERROR_RESOURCE_NOT_FOUND);
    }

    return result;
}

const std::string SurfaceRemoveNativeContentCommand::getString()
{
    std::stringstream description;
    description << "SurfaceRemoveNativeContentCommand("
                << "surfaceId=" << m_surfaceId << "(0x" << std::hex << m_surfaceId << ")" << std::dec
                << ")";
    return description.str();
}
